% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hazard_fun.R
\encoding{UTF-8}
\name{hazard_fun}
\alias{hazard_fun}
\title{Hazard functions for any distribution}
\usage{
hazard_fun(distr, log = FALSE)
}
\arguments{
\item{distr}{a length-one character vector with the name of density/mass function
of interest.}

\item{log}{logical; if TRUE, the natural logarithm of the hazard values are
returned.}
}
\value{
A function with the folling input arguments:
\item{x}{vector of (non-negative) quantiles.}
\item{...}{Arguments of the probability density/mass function.}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

This function takes the name of a probability density/mass function as an
argument and creates a hazard function.
}
\examples{
library(EstimationTools)

#----------------------------------------------------------------------------
# Example 1: Hazard function of the Weibull distribution.

# Hazard function in the 'maxlogL' framework
hweibull1 <- hazard_fun('dweibull')

# Hazard function from scratch
hweibull2 <- function(x, shape, scale){
  shape/scale * (x/scale)^(shape - 1)
}

# Comparison
hweibull1(0.2, shape = 2, scale = 1)
hweibull2(0.2, shape = 2, scale = 1)


#----------------------------------------------------------------------------

}
\seealso{
Other distributions utilities: 
\code{\link{cum_hazard_fun}()},
\code{\link{expected_value}()}
}
\author{
Jaime Mosquera Gutiérrez, \email{jmosquerag@unal.edu.co}
}
\concept{distributions utilities}
