% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Plots.R
\name{plotBiasCorrectionInference}
\alias{plotBiasCorrectionInference}
\title{Plot bias correction inference}
\usage{
plotBiasCorrectionInference(
  bbcResult,
  type = "raw",
  ids = bbcResult$Id,
  limits = c(-3, 3),
  logScale = FALSE,
  numericId = TRUE,
  fileName = NULL
)
}
\arguments{
\item{bbcResult}{A (sequential) analysis object generated by the \code{\link[=biasCorrectionInference]{biasCorrectionInference()}} function.}

\item{type}{The type of plot. Must be one of \code{c("corrected", "raw", "compare")}.}

\item{ids}{IDs of the periods/groups to plot result for; default is all IDs.}

\item{limits}{The limits on log RR for plotting.}

\item{logScale}{Whether or not to show bias in log-RR; default FALSE (shown in RR).}

\item{numericId}{Whether or not to treat \code{Id} as a numeric variable; default: TRUE.}

\item{fileName}{Name of the file where the plot should be saved, for example 'plot.png'. See
the function \link[ggplot2:ggsave]{ggplot2::ggsave} in the ggplot2 package for supported file
formats.}
}
\value{
A \code{ggplot} object. Use the \link[ggplot2:ggsave]{ggplot2::ggsave} function to save to file.
}
\description{
Plot bias correction inference
}
\details{
Plot empirical bias distributions learned from analyzing negative controls.
}
\examples{
# Perform sequential analysis using Bayesian bias correction for this example:
data("ncLikelihoods")
data("ooiLikelihoods")
# NOT RUN
# bbcSequential = biasCorrectionInference(ooiLikelihoods, ncLikelihoodProfiles = ncLikelihoods)

# Plot it
# NOT RUN
# plotBiasCorrectionInference(bbcSequential, type = "corrected")

}
\seealso{
\link{biasCorrectionInference}
}
