% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/import_equation.R
\name{import_equation}
\alias{import_equation}
\title{Import \code{EViews} equation data members into R, R Markdown or Quarto.}
\usage{
import_equation(wf = "", page = "*", equation = "*")
}
\arguments{
\item{wf}{Object or a character string representing the name of an \code{EViews} workfile.}

\item{page}{Object or a character string representing the name of an \code{EViews} workfile page.}

\item{equation}{Name(s) or wildcard expressions for \code{EViews} equation object(s) in an \code{EViews} workfile}
}
\value{
An EViews workfile
}
\description{
Use this function to import \code{EViews} equation data members into R, R Markdown or Quarto.
}
\examples{
library(EviewsR)
\dontrun{
demo(exec_commands)

import_equation(wf="exec_commands",page="eviewsPage",equation="OLS")

# To access the data members in base R

eviews$eviewspage_ols

# To obtain R-squared value in base R

eviews$eviewspage_ols$r2

# To get the values above in R Markdown or Quarto:

# chunkLabel$eviewspage_ols

# chunkLabel$eviewspage_ols$r2
}
}
\seealso{
Other important functions: 
\code{\link{EviewsR-package}},
\code{\link{create_object}()},
\code{\link{eng_eviews}()},
\code{\link{eviews_graph}()},
\code{\link{eviews_import}()},
\code{\link{eviews_pagesave}()},
\code{\link{eviews_wfcreate}()},
\code{\link{eviews_wfsave}()},
\code{\link{exec_commands}()},
\code{\link{export}()},
\code{\link{export_dataframe}()},
\code{\link{import}()},
\code{\link{import_graph}()},
\code{\link{import_kable}()},
\code{\link{import_series}()},
\code{\link{import_table}()},
\code{\link{import_workfile}()},
\code{\link{rwalk}()},
\code{\link{set_eviews_path}()}
}
\concept{important functions}
\keyword{documentation}
