% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ExpDE2.R
\name{ExpDE2}
\alias{ExpDE2}
\title{Experimental Differential Evolution - ExpDE}
\usage{
ExpDE2(method.name, problem.name, seed = NULL)
}
\arguments{
\item{method.name}{A specific method key name, generated by \code{\link{gen_methods}}. 
This must be a character string in the format "DE.[integer].[single letter]".}

\item{problem.name}{A specific problem key name, generated by \code{\link{gen_problems}}.
This must be a character string in the format "Prob.[integer].[integer]".}

\item{seed}{positive integer, seed for the random number generator.}
}
\value{
A single scalar value representing the final value returned by 
running the DE method specified by `method.name` on the problem specified 
by `problem.name`.
}
\description{
This function is an interface to call the main function \code{\link{ExpDE}}, 
usinga method specification generated by \code{\link{gen_methods}} and a 
problem specification generated by \code{\link{gen_problems}}. It is used to 
provide an easy data-generating process to study the experimental comparisons of 
algorithms. See the documentation of \code{\link{ExpDE}} for details of the 
underlying algorithm.
}
\examples{
library(ExpDE)
myprobs <- gen_problems(1234567, nprobs=10)
myalgos <- gen_methods(1234567)
onerun  <- ExpDE2(method.name  = "DE.1234567.A", 
                  problem.name = "Prob.1234567.6")

}
