% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/impute.R
\name{impute_x}
\alias{impute_x}
\title{Impute Missing Values in the Data}
\usage{
impute_x(object, x)
}
\arguments{
\item{object}{A fitted model object with an "imputed" attribute indicating columns to impute.}

\item{x}{A matrix or data frame}
}
\value{
A matrix with imputed values and additional columns for missingness indicators.
}
\description{
Imputes missing values in the data using median imputation based on the data  set.
}
\examples{
\donttest{
set.seed(123)
x <- matrix(rnorm(60), 10, 6)
colnames(x) <- paste0("X", 1:6)
x[1:2, 1] <- NA  # Introduce missing values
model <- list(imputed = c(1))
attr(model, "imputed") <- c(1)
x_imputed <- impute_x(model, x)
dim(x_imputed)  # 10 rows, 7 columns (6 original + 1 missingness indicator)
any(is.na(x_imputed))  # FALSE, no missing values
}
}
