% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/results.R
\name{model.string}
\alias{model.string}
\title{Function to Generate a Function String for a Model Consisting of Features}
\usage{
model.string(model, features, link = "I", round = 2)
}
\arguments{
\item{model}{A logical vector indicating which features to include}

\item{features}{The population of features}

\item{link}{The link function to use, as a string}

\item{round}{Rounding error for the features in the printed format}
}
\value{
A character representation of a model
}
\description{
Function to Generate a Function String for a Model Consisting of Features
}
\examples{
result <- gmjmcmc(y = matrix(rnorm(100), 100),
x = matrix(rnorm(600), 100), 
P = 2, transforms =  c("p0", "exp_dbl"))
summary(result)
plot(result)
model.string(c(TRUE, FALSE, TRUE, FALSE, TRUE), result$populations[[1]])
model.string(result$models[[1]][1][[1]]$model, result$populations[[1]])

}
