% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/is_metric_mat.R
\name{is_metric_cost_mat}
\alias{is_metric_cost_mat}
\title{Check metric properties of cost matrices}
\usage{
is_metric_cost_mat(x, tol.sym = 1e-08, tol.pd = 0, tol.ti = 1e-08)
}
\arguments{
\item{x}{numeric square matrix.}

\item{tol.sym}{tolerance used to check symmetry.}

\item{tol.pd}{tolerance used to check positive definiteness.}

\item{tol.ti}{tolerance used to check the triangle inequality.}
}
\value{
A list containing logical entries \code{metric}, \code{semi.metric}, \code{sym}, \code{pos.def}
and \code{tri.ineq} that indicate whether the corresponding property is satisfied.
}
\description{
Check if a cost matrix satisfies symmetry, positive definiteness and the triangle inequality.
}
\details{
The following three properties of a square matrix \eqn{x \in \mathbb{R}^{N \times N}}
are checked:
\itemize{
\item symmetry; if \eqn{x_{ij} = x_{ji}},
\item positive definiteness; if \eqn{x_{ii} = 0} and \eqn{x_{ij} > 0} for all \eqn{i \neq j},
\item triangle inequality; if \eqn{x_{ij} \leq x_{ik} + x_{kj}}.
}
If symmetry and positive definiteness are satisfied, then \eqn{x} is called a semi-metric
cost matrix. If additionally also the triangle inequality holds, then \eqn{x} is a
metric cost matrix.
}
\examples{
x <- cost_matrix_lp(1:5)
res <- is_metric_cost_mat(x)
res2 <- is_metric_cost_mat(x^2)
# x is a metric cost matrix
print(res$metric)
# x^2 is only a semi-metric cost matrix,
# because the triangle inequality is not satisfied
print(res2$semi.metric)
print(res2$tri.ineq)
}
\seealso{
\code{\link{cost_matrix_lp}}
}
