
#include<RcppArmadillo.h>

// [[Rcpp::export(rng = false)]]
bool hasOMP()
{
#ifdef _OPENMP
    return true;
#else
    return false;
#endif
}

// [[Rcpp::export(rng = false)]]
void setOMP(const int threads)
{
#ifdef _OPENMP
    if (threads > 0)
    {
        omp_set_num_threads(threads);
    }
#endif
}

// [[Rcpp::export(rng = false)]]
int getOMP()
{
#ifdef _OPENMP
    return omp_get_max_threads();
#else
    return -1;
#endif
}
