% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/util_gfft.R
\name{add_fft_df}
\alias{add_fft_df}
\title{Add an FFT definition to tree definitions}
\usage{
add_fft_df(fft, ffts_df = NULL, quiet = FALSE)
}
\arguments{
\item{fft}{A (set of) FFT definition(s)
(in the multi-line format of an \code{FFTrees} object)
or one FFT definition
(as a data frame in tidy format, with one row per node).}

\item{ffts_df}{A set of FFT definitions (as a data frame,
usually from an \code{FFTrees} object,
with suitable variable names to pass \code{verify_ffts_df}.
Default: \code{ffts_df = NULL}.}

\item{quiet}{Hide feedback messages (as logical)?
Default: \code{quiet = FALSE}.}
}
\value{
A (set of) FFT definition(s) in the one line
FFT definition format used by an \code{FFTrees} object
(as a data frame).
}
\description{
\code{add_fft_df} adds the definition(s) of
one or more FFT(s) (in the multi-line format of an \code{FFTrees} object)
or a single FFT (as a tidy data frame)
to the multi-line FFT definitions of an \code{FFTrees} object.

\code{add_fft_df} allows for collecting and combining
(sets of) tree definitions after
manipulating them with other tree trimming functions.
}
\seealso{
\code{\link{get_fft_df}} for getting the FFT definitions of an \code{FFTrees} object;
\code{\link{read_fft_df}} for reading one FFT definition from tree definitions;
\code{\link{write_fft_df}} for writing one FFT to tree definitions;
\code{\link{FFTrees}} for creating FFTs from and applying them to data.

Other tree definition and manipulation functions: 
\code{\link{add_nodes}()},
\code{\link{drop_nodes}()},
\code{\link{edit_nodes}()},
\code{\link{flip_exits}()},
\code{\link{get_fft_df}()},
\code{\link{read_fft_df}()},
\code{\link{reorder_nodes}()},
\code{\link{select_nodes}()},
\code{\link{write_fft_df}()}
}
\concept{tree definition and manipulation functions}
