% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/util_abc.R
\name{get_best_tree}
\alias{get_best_tree}
\title{Select the best tree (from current set of FFTs)}
\usage{
get_best_tree(x, data, goal, my.goal.max = TRUE)
}
\arguments{
\item{x}{An \code{FFTrees} object.}

\item{data}{The type of data to consider (as character: either 'train' or 'test').}

\item{goal}{A goal (as character) to be maximized or minimized when selecting a tree
from an existing \code{FFTrees} object \code{x} (with existing \code{x$trees$stats}).}

\item{my.goal.max}{Default direction for user-defined \code{my.goal} (as logical):
Should \code{my.goal} be maximized?
Default: \code{my.goal.max = TRUE}.}
}
\value{
An integer denoting the \code{tree} that maximizes/minimizes \code{goal} in \code{data}.
}
\description{
\code{get_best_tree} selects (looks up and identifies) the best tree (as an integer)
from the set (or \dQuote{fan}) of FFTs contained in the current \code{FFTrees} object \code{x},
an existing type of \code{data} ('train' or 'test'), and
a \code{goal} for which corresponding statistics are available
in the designated \code{data} type (in \code{x$trees$stats}).
}
\details{
Importantly, \code{get_best_tree} only identifies and selects the `tree` \emph{identifier}
(as an integer) from the set of \emph{existing} trees with known statistics,
rather than creating new trees or computing new cue thresholds.
More specifically, \code{goal} is used for identifying and selecting the `tree`
identifier (as an integer) of the best FFT from an existing set of FFTs, but not for
computing new cue thresholds (see \code{goal.threshold} and \code{fftrees_cuerank()}) or
creating new trees (see \code{goal.chase} and \code{fftrees_ranktrees()}).
}
\seealso{
\code{\link{FFTrees}} for creating FFTs from and applying them to data.

Other utility functions: 
\code{\link{get_exit_type}()},
\code{\link{get_fft_df}()}
}
\concept{utility functions}
