% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/run_sim_3plus3.R
\name{run_sim_3plus3}
\alias{run_sim_3plus3}
\title{Simulations for the 3+3 design.}
\usage{
run_sim_3plus3(p.true,
                 mtd.true,
                startdose = 1,
                ntrial = 1000,
                seed = 6)
}
\arguments{
\item{p.true}{a vector or matrix containing the true toxicity probabilities of the investigational dose levels.}

\item{mtd.true}{a numeric value or a vector which specifies the true MTD.}

\item{startdose}{a numeric value; the starting dose level for the trial.}

\item{ntrial}{a numeric value; the total number of simulated trials.}

\item{seed}{a numeric value; the random seed for simulation.}
}
\value{
\code{run_sim_3plus3()} returns:

(1) a dataframe (\code{$selection}) with each column showing:
       the numbered index for each scenarios specified,
       the name of the design,
       the selection percentage at each dose level,
       the percentage of early stopping without selecting the MTD,
       the percentage of overdosing selection (POS),
       the percentage of correct selection (PCS),
       the percentage of underdosing selection (PUS),
       the numbered index for the true MTD, respectively.

(2) a dataframe (\code{$allocation}) with each column showing:
       the numbered index for each scenarios specified,
       the name of the design,
       the number of participants treated at each dose level,
       the average number of participants treated,
       the percentage of overdosing assignment (POA),
       the percentage of correct assignment (PCA),
       the percentage of underdosing assignment (PUA),
       the numbered index for the true MTD, respectively.

(3) a list (\code{$setup}) containing user input parameters.
}
\description{
Conduct computer simulations for the 3+3 design.
}
\details{
The 3+3 design uses the following decision rules.

(1). Start trial by treating three participants at the initial dose.

(2). Denote the dose level being used to treat participants as the current dose level.
     Treat three participants at the current dose level.

(3). Check the number of participants at the current dose level.

3a. If there are three participants, go to (4).

3b. If there are six participants, go to (5).

(4). Check the number of toxicities (among three participants) at the current dose level.

4a. If there are zero toxicities, escalate and go to (7).

4b. If there is one toxicity, stay at the current dose and go to (2).

4c. If there are two or three toxicities, declare that the MTD has been exceeded and go to (6).

(5). Check the number of toxicities (among six participants) at the current dose level.

5a. If there are zero toxicities, stop the trial and declare that the MTD is the current dose.

5b. If there is one toxicity, and the MTD has been exceeded, stop the trial and declare that
the MTD is the current dose; otherwise, go to (7).

5c. If there are two or more than two toxicities, declare that the MTD has been exceeded and go to (6).

(6). The MTD has been exceeded.

6a. If the current dose is the lowest dose, stop the trial and declare that the MTD is lower than
the lowest dose level.

6b. If then next-lower dose level has six participants, stop the trial and declare that the MTD is the
next lower dose level; otherwise, the next lower dose level has three participants; set the current dose
level to be the next-lower dose level and go to (2).

(7). Escalate if possible.

7a. If the current dose level is the highest dose level, stop the trial and declare that the MTD is
the highest dose level.

7b. Otherwise, escalate to the next higher dose level and go to (2).
}
\examples{
run_sim_3plus3(p.true = c(0.25, 0.41, 0.45, 0.49, 0.53),
          mtd.true = c(1,0,0,0,0),
          startdose = 1,
          ntrial = 1000,
          seed = 6)

}
\references{
Storer B. (1989). Design and analysis of phase i clinical trials, \emph{Biometrics}, 925–937.

Yang, S., Wang, S.J. and Ji, Y., (2015). An integrated dose-finding tool for phase I trials in oncology. \emph{Contemporary clinical trials}, 45, pp.426-434.
}
