% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metaheuristic.R
\name{geneticAlgorithm}
\alias{geneticAlgorithm}
\title{Genetic Algorithm}
\usage{
geneticAlgorithm(
  popSize = 20,
  pcrossover = 0.8,
  pmutation = 0.1,
  maxiter = 100,
  run = 100,
  verbose = FALSE
)
}
\arguments{
\item{popSize}{The popuplation size}

\item{pcrossover}{The probability of crossover between individuals}

\item{pmutation}{The probability of mutation between individuals}

\item{maxiter}{The number of iterations}

\item{run}{Number of consecutive iterations without fitness improvement to stop the algorithm}

\item{verbose}{Print the partial results in each iteration. This functionality is not available if the objective of the evaluation method is to minimize the target value (e.g. regression methods)}
}
\value{
Returns a search function that is used to guide the feature selection process.
}
\description{
Generates a search function based on a genetic algorithm. This function is called internally within the \code{\link{searchAlgorithm}} function. The geneticAlgorithm method \insertCite{yang1998feature}{FSinR} starts with an initial population of solutions and at each step applies a series of operators to the individuals in order to obtain new and better population of individuals. These operators are selection, crossing and mutation methods. This method uses the GA package implementation \insertCite{GAPkg1}{FSinR} \insertCite{GAPkg2}{FSinR}.
}
\examples{
\donttest{ 

## The direct application of this function is an advanced use that consists of using this 
# function directly and performing a search process in a feature space
## Classification problem

# Generates the filter evaluation function
filter_evaluator <- filterEvaluator('IEConsistency')

# Generates the search function with Genetic algorithm
ga_search <- geneticAlgorithm()
# Performs the search process directly (parameters: dataset, target variable and evaluator)
ga_search(iris, 'Species', filter_evaluator)
}
}
\references{
\insertAllCited{}
}
\author{
Francisco Aragón Royón
}
