% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/survfitmvjmcs.R
\name{survfitmvjmcs}
\alias{survfitmvjmcs}
\title{Prediction in Joint Models}
\usage{
survfitmvjmcs(
  object,
  seed = 100,
  ynewdata = NULL,
  cnewdata = NULL,
  u = NULL,
  Last.time = NULL,
  obs.time = NULL,
  LOCF = FALSE,
  LOCFcovariate = NULL,
  clongdata = NULL,
  ...
)
}
\arguments{
\item{object}{an object inheriting from class \code{mvjmcs}.}

\item{seed}{a random seed number to proceed Monte Carlo simulation. Default is 100.}

\item{ynewdata}{a data frame that contains the longitudinal and covariate information for the subjects 
for which prediction of survival probabilities is required.}

\item{cnewdata}{a data frame that contains the survival and covariate information for the subjects 
for which prediction of survival probabilities is required.}

\item{u}{a numeric vector of times for which prediction survival probabilities are to be computed.}

\item{Last.time}{a numeric vector or character string. This specifies the known time at which each of 
the subjects in cnewdata was known to be alive. If NULL, then this is automatically taken as the 
survival time of each subject. If a numeric vector, then it is assumed to be greater than or equals to the 
last available longitudinal time point for each subject. If a character string, then it should be 
a variable in cnewdata.}

\item{obs.time}{a character string of specifying a longitudinal time variable in ynewdata.}

\item{LOCF}{a logical value to indicate whether the last-observation-carried-forward approach applies to prediction. 
If \code{TRUE}, then \code{LOCFcovariate} and \code{clongdata} must be specified to indicate 
which time-dependent survival covariates are included for dynamic prediction. Default is FALSE.}

\item{LOCFcovariate}{a vector of string with time-dependent survival covariates if \code{LOCF = TRUE}. Default is NULL.}

\item{clongdata}{a long format data frame where time-dependent survival covariates are incorporated. Default is NULL.}

\item{...}{further arguments passed to or from other methods.}
}
\value{
a list of matrices with conditional probabilities for subjects.
}
\description{
This function computes the conditional probability of 
surviving later times than the last observed time for which a longitudinal 
measurement was available.
}
\seealso{
\code{\link{mvjmcs}}
}
\author{
Shanpeng Li \email{lishanpeng0913@ucla.edu}
}
