% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/server.R
\name{withStopMessage}
\alias{withStopMessage}
\title{Try expression with predefined error message}
\usage{
withStopMessage(expr)
}
\arguments{
\item{expr}{The expression to execute}
}
\value{
The result of the expression
}
\description{
Executes an expression and prints an error message if it fails
}
\examples{
f <- function(expr) {
  val <- try(expr, silent = TRUE)
  err <- if (inherits(val, "try-error")) attr(val, "condition") else NULL
  if (!is.null(err)) value <- NULL
  list(value = val, error = err)
}
ret <- f(log("a")) # this error will not show up in the console
ret <- f(withStopMessage(log("a"))) # this error will show up in the console

}
\keyword{internal}
