% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/4_create_depth_stats.R
\name{create_depth_stats}
\alias{create_depth_stats}
\title{Create depth statistics}
\usage{
create_depth_stats(
  archive,
  tag_ID,
  diel = FALSE,
  sunrise_time = NULL,
  sunset_time = NULL,
  GPS = FALSE,
  sunset_type = "civil",
  output = FALSE,
  output_folder = NULL,
  verbose = FALSE
)
}
\arguments{
\item{archive}{Data frame containing processed time series depth data}

\item{tag_ID}{Unique tag identification number in a vector of characters.
E.g. "123456"}

\item{diel}{Include diel statistics when TRUE}

\item{sunrise_time}{Sunrise time (local time zone) in 24-hour clock. E.g.
"05:45:00"}

\item{sunset_time}{Sunset time (local time zone) in 24-hour clock. E.g.
"18:30:00"}

\item{GPS}{Either FALSE or the location of the GPS file containing columns
'date', 'lat' (latitude) and 'lon' (longitude) if one exists. 'date'
columns must be in a format readable by lubridate::dmy()}

\item{sunset_type}{Choose which type of sunset to include 'NULL', 'civil',
'nautical', or 'astronomical'}

\item{output}{Logical. If TRUE, output is saved to \code{output_folder}.
Defaults to FALSE.}

\item{output_folder}{Output folder path. If \code{output = TRUE},
\code{output_folder} must be provided. Defaults to NULL.}

\item{verbose}{Logical. If TRUE, progress messages are shown. Defaults to FALSE.}
}
\value{
A set of statistics calculated daily for the depth data. If diel
is 'TRUE', additional diel statistics will be returned. An attribute
'diel' with value 'TRUE' is given when diel statistics are included.
}
\description{
\code{create_depth_stats} creates the various daily and diel depth statistics
for each day
}
\examples{
# Set file path
filepath <- system.file("extdata", package = "FishDiveR")

# Load archive_days
archive_days <- readRDS(file.path(filepath, "data/archive_days.rds"))

# Run create_depth_stats function
depthStats <- create_depth_stats(
  archive = archive_days,
  tag_ID = "data",
  diel = TRUE,
  sunrise_time = "06:00:00",
  sunset_time = "18:00:00",
  GPS = file.path(filepath, "data/GPS.csv"),
  sunset_type = "civil",
  output = TRUE,
  output_folder = tempdir(),
  verbose = TRUE
)

}
