% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/6_pca_results.R
\name{pca_results}
\alias{pca_results}
\title{Perform Principal Component Analysis}
\usage{
pca_results(
  pc_data,
  standardise = TRUE,
  No_pcs = NULL,
  PCV = NULL,
  plot_eigenvalues = TRUE,
  output = FALSE,
  output_folder = NULL,
  verbose = FALSE,
  interactive_mode = TRUE
)
}
\arguments{
\item{pc_data}{Data frame containing the output of the pca_data() function.}

\item{standardise}{TRUE or FALSE. Whether or not to standardise the data.
Default TRUE.}

\item{No_pcs}{Numerical. Number of principal components to retain. Null by
default}

\item{PCV}{Numerical. Percentage of cumulative variance to retain. Null by
default}

\item{plot_eigenvalues}{TRUE or FALSE. Plot PC eigenvalues and general
loadings. Default TRUE.}

\item{output}{Logical. If TRUE, output is saved to \code{output_folder}.
Defaults to FALSE.}

\item{output_folder}{Output folder path. If \code{output = TRUE},
\code{output_folder} must be provided. Defaults to NULL.}

\item{verbose}{Logical. If TRUE, progress messages are shown. Defaults to FALSE.}

\item{interactive_mode}{TRUE or FALSE. Used for testing the package. Default
FALSE.}
}
\value{
A PCA object from 'FactoMineR' package containing the output of the
Principal Component Analysis.
}
\description{
\code{pca_results} performs Principal Component Analysis on the pc_data data frame
containing statistics from wavelet analysis
}
\examples{
# Set file path
filepath <- system.file("extdata", package = "FishDiveR")

# Load pc_data
pc_data <- readRDS(file.path(filepath, "data/4_PCA/pc_data.rds"))


# Run a minimal, fast pca_results example
pc_results <- pca_results(
  pc_data = pc_data,
  standardise = TRUE,
  No_pcs = 1,
  PCV = NULL,
  plot_eigenvalues = FALSE,
  output = TRUE,
  output_folder = tempdir(),
  verbose = TRUE,
  interactive_mode = FALSE
)

\donttest{
# Full example using the complete dataset
# Run pca_results function
pc_results <- pca_results(
  pc_data = pc_data,
  standardise = TRUE,
  No_pcs = 3,
  PCV = NULL,
  plot_eigenvalues = TRUE,
  output = TRUE,
  output_folder = tempdir(),
  verbose = TRUE,
  interactive_mode = FALSE
)
}

}
