% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/1_import_tag_data.R
\name{plot_TDR}
\alias{plot_TDR}
\title{Plot the time-series depth dataset}
\usage{
plot_TDR(
  rds_file,
  data_folder = NULL,
  every_nth = 20,
  every_s = 0,
  plot_size = c(12, 6),
  X_lim = NULL,
  Y_lim = c(0, 1500, 100),
  date_breaks = "14 day",
  dpi = 300,
  output = FALSE,
  output_folder = NULL,
  verbose = FALSE
)
}
\arguments{
\item{rds_file}{Character vector file path of rds file.
E.g. ("E:/data/archive_days.rds")}

\item{data_folder}{Parent folder path with separate folders for each tag
data. E.g. "C:/Tag data". Defaults to 'data_dir'}

\item{every_nth}{Numerical. Optional down-sampling of data points to plot.
Defaults to 10, plotting every 10th record.}

\item{every_s}{Numerical. Alternative to every_nth. Optional down-sampling
of data points to plot by number of seconds, as opposed to records. E.g.
plots every 60th second, rather than 10th row of data. Must be a multiple of the
sampling frequency. Overrides every_nth if != 0.}

\item{plot_size}{ggSave height and width for saving the output plot. Must be
numeric, positive and 2 elements long. Default to 'c(12,6)'}

\item{X_lim}{Optional. Vector with two dates delimiting the time-depth record
to plot. E.g. c("2000-01-01", "2000-11-23")}

\item{Y_lim}{Character vector with minimum depth, maximum depth, and sequence
for ticks on Y-axis. Must be numeric, positive and 3 elements long. E.g.
c(0,1500,100).}

\item{date_breaks}{X-axis ggplot2 date breaks. E.g, "24 hour, "3 day",
"2 week".}

\item{dpi}{Numerical. DPI to use for 'ggsave()' output. E.g, 600}

\item{output}{Logical. If TRUE, a plot file is saved to \code{output_folder}. Defaults to FALSE.}

\item{output_folder}{Output folder path used when \code{output = TRUE}. Defaults to NULL.}

\item{verbose}{Logical. If TRUE, progress messages are shown. Defaults to FALSE.}
}
\value{
A data frame of plot data
}
\description{
This function plots the time-series depth data from the imported tag.
}
\examples{
# Set file path
filepath <- system.file("extdata", package = "FishDiveR")

# Run plot_TDR function
TDR_plot <- plot_TDR(
  rds_file = "data/archive_days.rds",
  data_folder = filepath,
  every_nth = 10,
  every_s = 0,
  plot_size = c(12, 6),
  X_lim = NULL,
  Y_lim = c(0, 300, 50),
  date_breaks = "24 hour",
  dpi = 100,
  output = TRUE,
  output_folder = tempdir(),
  verbose = TRUE
)

}
