% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/9_plot_cluster_TDR.R
\name{plot_cluster_TDR}
\alias{plot_cluster_TDR}
\title{Plot the time-series depth records of the selected tag. Colour days by
cluster}
\usage{
plot_cluster_TDR(
  tag_ID,
  data_folder = NULL,
  kmeans_result,
  every_nth = 10,
  every_s = 0,
  X_lim = NULL,
  Y_lim = c(0, 250, 50),
  date_breaks = "14 day",
  legend = TRUE,
  plot_size = c(12, 6),
  dpi = 300,
  output = FALSE,
  output_folder = NULL,
  verbose = FALSE
)
}
\arguments{
\item{tag_ID}{Unique tag identification number in a vector of characters.
E.g. "123456".}

\item{data_folder}{Parent folder path with separate folders for each tag
data. E.g. "C:/Tag data". Defaults to 'data_dir'}

\item{kmeans_result}{An object of class 'kmeans' containing the k-means
clustering data. Output of 'k_clustering()' function.}

\item{every_nth}{Numerical. Optional down-sampling of data points to plot.
Defaults to 10, plotting every 10th record.}

\item{every_s}{Numerical. Alternative to every_nth. Optional down-sampling
of data points to plot by number of seconds, as opposed to records. E.g.
plots every 60th second, rather than 10th row of data. Must be a multiple of the
sampling frequency. Overrides every_nth if != 0.}

\item{X_lim}{Optional. Vector with two dates delimiting the time-depth record
to plot. E.g. c("2000-01-01", "2000-11-23")}

\item{Y_lim}{Character vector with minimum depth, maximum depth, and sequence
for ticks on Y-axis. Must be numeric, positive and 3 elements long. E.g.
c(0,1500,100).}

\item{date_breaks}{X-axis ggplot2 date breaks. E.g, "24 hour, "3 day",
"2 week".}

\item{legend}{TRUE or FALSE. Whether or not to plot the figure legend.
Defaults to TRUE.}

\item{plot_size}{ggSave height and width for saving the output plot. Must be
numeric, positive and 2 elements long. Default to 'c(12,6)'}

\item{dpi}{Numerical. DPI to use for 'ggsave()' output. E.g, 600}

\item{output}{Logical. If TRUE, output is saved to \code{output_folder}.
Defaults to FALSE.}

\item{output_folder}{Output folder path. If \code{output = TRUE},
\code{output_folder} must be provided. Defaults to NULL.}

\item{verbose}{Logical. If TRUE, progress messages are shown. Defaults to FALSE.}
}
\value{
Returns the cluster TDR plot. Additionally prints to file the TDR
plot. Additionally outputs a facet plot of all tag_IDs.
}
\description{
\code{plot_cluster_TDR} plots the time-series depth record of the selected
archival tag. Each day of data is coloured by the assigned cluster, this
helps to visualise changes in vertical movement behaviour over time.
}
\examples{
# Set file path
filepath <- system.file("extdata", package = "FishDiveR")

# Load kmeans_result
kmeans_result <- readRDS(file.path(filepath, "data/5_k-means/kmeans_result.rds"))

# Run plot_clusters function
plot_cluster_TDR(
  tag_ID = "data",
  data_folder = filepath,
  kmeans_result = kmeans_result,
  every_nth = 10,
  every_s = 0,
  X_lim = NULL,
  Y_lim = c(0, 300, 50),
  date_breaks = "1 day",
  legend = TRUE,
  plot_size = c(12, 6),
  dpi = 100,
  output = TRUE,
  output_folder = tempdir(),
  verbose = TRUE
)

}
