% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/10_plot_clusters.R
\name{plot_clusters}
\alias{plot_clusters}
\title{Plot the time-series depth records of the days closest to the centre of each
cluster}
\usage{
plot_clusters(
  tag_vector = tag_list,
  data_folder = NULL,
  kmeans_result,
  No_days = 1,
  every_nth = 10,
  every_s = 0,
  Y_lim = c(0, 250, 50),
  color = TRUE,
  diel_shade = FALSE,
  dpi = 300,
  output = FALSE,
  output_folder = NULL,
  verbose = FALSE
)
}
\arguments{
\item{tag_vector}{A character vector of tag IDs. E.g. 'c("123456", "456283",
"AB98XJ").}

\item{data_folder}{Parent folder path with separate folders for each tag
data. E.g. "C:/Tag data". Defaults to 'data_dir'}

\item{kmeans_result}{An object of class 'kmeans' containing the k-means
clustering data. Output of 'k_clustering()' function.}

\item{No_days}{Numerical. Number of days of each cluster to plot. Defaults to
1.}

\item{every_nth}{Numerical. Optional down-sampling of data points to plot.
Defaults to 10, plotting every 10th record.}

\item{every_s}{Numerical. Alternative to every_nth. Optional down-sampling
of data points to plot by number of seconds, as opposed to records. E.g.
plots every 60th second, rather than 10th row of data. Must be a multiple of the
sampling frequency. Overrides every_nth if != 0.}

\item{Y_lim}{Character vector with minimum depth, maximum depth, and sequence
for ticks on Y-axis. Must be numeric, positive and 3 elements long. E.g.
c(0,1500,100).}

\item{color}{TRUE or FALSE. Output clusters coloured by cluster assignment.
Defaults to TRUE.}

\item{diel_shade}{TRUE or FALSE. Output plot with night-time shading. Can
be slow! Defaults to FALSE.}

\item{dpi}{Numerical. DPI to use for 'ggsave()' output. E.g, 600}

\item{output}{Logical. If TRUE, output is saved to \code{output_folder}.
Defaults to FALSE.}

\item{output_folder}{Output folder path. If \code{output = TRUE},
\code{output_folder} must be provided. Defaults to NULL.}

\item{verbose}{Logical. If TRUE, progress messages are shown. Defaults to FALSE.}
}
\value{
A plot list of all plots created of each cluster in the data. When
output == TRUE this prints to file one figure for each Cluster with a fixed
y-axis. Additionally outputs a facet plot of all clusters, and a free
y-axis version of all plots.
}
\description{
\code{plot_clusters} plots the time-depth records of the days closest to the
centre of each of the clusters. Each cluster is plotted both individually,
and faceted together, with both a fixed y-axis and a free y-axis (depth).
}
\examples{
# Set file path
filepath <- system.file("extdata", package = "FishDiveR")

# Load kmeans_result
kmeans_result <- readRDS(file.path(filepath, "data/5_k-means/kmeans_result.rds"))

# Run plot_clusters function
plot_clusters(
  tag_vector = "data",
  data_folder = filepath,
  kmeans_result = kmeans_result,
  No_days = 1,
  every_nth = 10,
  every_s = 0,
  Y_lim = c(0, 300, 50),
  color = TRUE,
  diel_shade = FALSE,
  dpi = 100,
  output = TRUE,
  output_folder = tempdir(),
  verbose = TRUE
)

}
