% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/forecast_eval_functions.R
\name{dm.test.r}
\alias{dm.test.r}
\title{Diebold-Mariano Test (with an original recommendation)}
\usage{
dm.test.r(d, h = 1, cl = 0.05)
}
\arguments{
\item{d}{loss differential}

\item{h}{h-step-ahead forecast (default = 1, i.e., comparing one-step-ahead forecasts)}

\item{cl}{confidence level (default = 0.05, i.e., 5\%)}
}
\value{
This function returns a class with the following elements
\itemize{
\item \code{rej} is a T/F value. TRUE (reject), FALSE (accept)
\item \code{stat} is a test statistic
\item \code{pval} is an associated p-value
}
}
\description{
This function performs the Diebold-Mariano test with their original recommendation.
Let \eqn{d_{t}}{d(t)} be a sequence of loss differential, \eqn{t=1,2,...,T}.
Then, the function performs a statistical test for the following null hypothesis:
\deqn{E[d_{t}] = 0}{E[d(t)] = 0}
This function follows the original recommendation by Diebold and Mariano (1995),
where the long-run variance is estimated using the rectangular kernel truncated at
\eqn{(h-1)}. This function performs a two-sided test. Normal approximation is used to calculate critical values.
}
\author{
Minchul Shin
}
