% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/h_standard_bv.R
\name{h_standard_bv_core}
\alias{h_standard_bv_core}
\title{Core Function for calculating Individual Tree Heights with the Bavarian
Standard Height Curve System}
\usage{
h_standard_bv_core(species_id, dbh_cm, age_yr, d_q_cm, h_q_m, params)
}
\arguments{
\item{species_id}{Vector of species ids (see \code{\link{h_standard_bv}}),
but for this core function to work, \code{species_id} must be provided as
\code{character}. This will and should be not checked inside this function,
because if used as intended, that has happened before calling it.}

\item{dbh_cm}{Diameter at breast height vector (see documentation of
\code{\link{h_standard_bv}})}

\item{age_yr}{Stand age vector (see documentation of
\code{\link{h_standard_bv}})}

\item{d_q_cm}{Stand mean diameter vector (see documentation of
\code{\link{h_standard_bv}})}

\item{h_q_m}{Stand mean height vector (see documentation of
\code{\link{h_standard_bv}})}

\item{params}{A data frame that defines the function parameters corresponding
to the species coding represented by \code{species_id}}
}
\value{
A vector of the estimated heights
}
\description{
See documentation of \code{\link{h_standard_bv}} for most information, this
function is the workhorse behind, and should never be called directly by a
user.
}
\details{
The function \code{h_standard_bv} is fully vectorized, inputs are recyled
according to the tibble rules
}
\keyword{internal}
