#' Function to estimate gene-level p-value using Davies algorithm
#'
#' @param matrix.ld A symmetric squared matrix containing the pairwise linkage disequilibrium between markers in a chromosome
#' @param marker_pvalues A vector with the p-values for the SNPs annotated within each gene
#' @return A vector of p-values for each gene annotated within the defined coordinates
#' @importFrom Matrix sparseMatrix
#' @importFrom Matrix Diagonal
#' @importFrom CompQuadForm liu
#' @name Liu_ld
#' @keywords internal

Liu_ld<-function(matrix.ld,marker_pvalues){
  
  ###Getting eingenvalues from the correlation matrix
  eigen_res<-eigen(matrix.ld)$values
  
  out.liu<-CompQuadForm::liu(sum(qnorm(marker_pvalues)^2),eigen_res)
  
  return(out.liu)
  
}