% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gareg_knots.R
\name{cptgaControl}
\alias{cptgaControl}
\title{Build Control List for \code{cptga}/\code{cptgaisl}}
\usage{
cptgaControl(
  ...,
  .list = NULL,
  .persist = FALSE,
  .env = asNamespace("GAReg"),
  .validate = TRUE,
  engine = NULL
)
}
\arguments{
\item{...}{Named overrides for control fields (e.g., \code{popSize},
\code{pcrossover}, \code{minDist}, \code{numIslands}).}

\item{.list}{Optional named list of overrides (merged with \code{...}).}

\item{.persist}{Logical; if \code{TRUE}, persist updated defaults back into
the target environment (not usually recommended in user code).}

\item{.env}{Environment where defaults live (defaults to \code{parent.frame()}).}

\item{.validate}{Logical; validate values/ranges (default \code{TRUE}).}

\item{engine}{Character; one of \code{"cptga"} or \code{"cptgaisl"} to select
the default set and validation rules.}
}
\value{
A list of class \code{"cptgaControl"}.
}
\description{
Convenience constructor for GA control parameters used by
\code{changepointGA::cptga} and \code{changepointGA::cptgaisl}. It merges
named overrides into engine-specific defaults
(\link{.cptga.default} or \link{.cptgaisl.default}), with light validation.
}
\details{
Unknown names are rejected. When both \code{...} and \code{.list} are present,
they are combined, with later entries overwriting earlier ones.
}
\seealso{
\link{gareg_knots}, \link{.cptga.default}, \link{.cptgaisl.default}
}
