% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gareg_knots.R
\name{crossover_fixknots}
\alias{crossover_fixknots}
\title{Crossover Operator (Fixed-\eqn{m}) with Feasibility-First Restarts}
\usage{
crossover_fixknots(mom, dad, prange = NULL, minDist, lmax, N)
}
\arguments{
\item{mom, dad}{Integer vectors encoding parent chromosomes:
first entry \eqn{m} (number of changepoints), followed by \eqn{m} ordered
knot locations.}

\item{prange}{Unused placeholder (kept for compatibility with other GA
operators). Default \code{NULL}.}

\item{minDist}{Integer; minimum spacing between adjacent knots in the child.}

\item{lmax}{Integer; chromosome length (number of rows in the population
matrix).}

\item{N}{Integer; series length. Used to place the sentinel \code{N+1} at
position \code{m+2}.}
}
\value{
An integer vector of length \code{lmax} encoding the child chromosome:
\code{c(m, child_knots, N+1, 0, 0, ...)}.
}
\description{
Produces a child chromosome from two fixed-\eqn{m} parents (same number of
knots) by alternately sampling candidate knot locations from the parents and
enforcing the spacing constraint \code{diff(child) > minDist}. If a conflict
is encountered, the routine restarts the construction up to a small cap.
}
\details{
Let \code{mom} and \code{dad} be chromosomes of the form
\code{c(m, tau_1, ..., tau_m, ...)}. This operator:
\enumerate{
  \item Initializes an empty child of size \eqn{m}.
  \item Picks the first knot at random from \code{mom} or \code{dad}.
  \item For each subsequent position \eqn{i=2,\dots,m}, considers the
        pair \code{(mom[i], dad[i])} and chooses the first value that
        maintains the spacing constraint relative to the previously chosen
        knot (\code{> minDist}); if both work, one is chosen at random.
  \item If no feasible choice exists at some step, the construction restarts
        from the first position (up to a small cap governed internally by
        \code{up_tol}).
}
The result is written back as a full-length chromosome with the sentinel
\code{N+1} in position \code{m+2}, and zeros elsewhere.
}
\examples{
\donttest{
N <- 120
lmax <- 30
minDist <- 5
m <- 3
mom <- c(m, c(20, 50, 90), rep(0, lmax - 1 - m))
mom[m + 2] <- N + 1
dad <- c(m, c(18, 55, 85), rep(0, lmax - 1 - m))
dad[m + 2] <- N + 1
child <- crossover_fixknots(mom, dad, minDist = minDist, lmax = lmax, N = N)
child
}

}
\seealso{
\link{crossover_fixknots}, \link{mutation_fixknots},
\link{selectTau_uniform_exact}, \link{Popinitial_fixknots},
\link{gareg_knots}
}
