% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vcov_functions.R
\name{vcov_global_factor}
\alias{vcov_global_factor}
\title{Get the covariance estimates for the global factors}
\usage{
vcov_global_factor(object, t)
}
\arguments{
\item{object}{An S3 object of class 'multi_result' created by [multilevel()].}

\item{t}{An integer specifying the time}
}
\value{
An \eqn{r_{0} \times r_{0}} covariance matrix.
}
\description{
This function generates the covariance estimates for the global factors
at time \eqn{t}.
}
\examples{

panel <- UKhouse # load the data
est_multi <- multilevel(panel, ic = "BIC3", standarise = TRUE, r_max = 5,
                           depvar_header = "dlPrice", i_header = "Region",
                           j_header = "LPA_Type", t_header = "Date")
vcov <- vcov_global_factor(est_multi, t = est_multi$T / 2)
}
