% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dagnelie_br.R
\name{dagnelie_br}
\alias{dagnelie_br}
\title{Single-entry Dagnelie branch volume (tarif "br")}
\usage{
dagnelie_br(data, output = NULL)
}
\arguments{
\item{data}{A \code{data.frame} containing at least:
\itemize{
\item \code{c130}: stem circumference at 1.30 m (cm),
\item \code{species_code}: tree species code.
}}

\item{output}{Optional file path where the resulting data frame should be
exported as a CSV. If NULL (default), no file is written.
Export is handled by the utility function \code{export_output()} and
failures trigger warnings without interrupting execution.}
}
\value{
A \code{data.frame} identical to the input \code{data} but augmented with:
\itemize{
\item species-specific coefficients and validity ranges,
\item \code{dagnelie_br}: the computed Dagnelie tarif-"br" branch volume (m\eqn{^3} per tree).
}
}
\description{
Computes the branch volume \eqn{v_{br}} (in cubic metres per tree)
using Dagnelie's single-entry "br" equations.
The branch volume is derived from the stem circumference at 1.30 m (\code{c130}, in cm)
and the tree species, using species-specific polynomial coefficients stored
in the reference table \code{danbr}.
}
\details{
The "br" tarif branch volume is calculated as:
\deqn{
  v_{br} = a + b\,c130 + c\,c130^2 + d\,c130^3
}
where \eqn{a}, \eqn{b}, \eqn{c}, and \eqn{d} are species-specific coefficients.

The function performs the following steps:
\itemize{
\item checks that the input data frame contains the required
variables \code{c130} and \code{species_code},
\item validates that \code{c130} is numeric,
\item verifies that all species are available in the \code{danbr}
reference table and issues a warning otherwise,
\item merges the input with \code{danbr} to retrieve coefficients
and species-specific validity ranges (\code{min_c130}, \code{max_c130}),
\item warns when \code{c130} values fall outside the recommended range,
\item computes tarif-"br" branch volume and returns the augmented data frame.
}

If one or more species codes are not found in \code{danbr}, the function issues
a warning and returns \code{NA}-values for missing coefficients and volumes.
Trees with \code{c130} values outside the recommended species-specific range
produce a warning but still receive a computed branch volume.
}
\section{Supported species}{

The following species codes are supported by \code{dagnelie_br}:
\itemize{
\item \code{"QUERCUS_SP"},
\item \code{"QUERCUS_ROBUR"},
\item \code{"QUERCUS_PETRAEA"},
\item \code{"QUERCUS_PUBESCENS"},
\item \code{"QUERCUS_RUBRA"}
\item \code{"FAGUS_SYLVATICA"},
\item \code{"ACER_PSEUDOPLATANUS"},
\item \code{"FRAXINUS_EXCELSIOR"},
\item \code{"ULMUS_SP"},
\item \code{"PRUNUS_AVIUM"}
\item \code{"BETULA_SP"},
\item \code{"ALNUS_GLUTINOSA"},
\item \code{"LARIX_SP"},
\item \code{"PINUS_SYLVESTRIS"},
\item \code{"CRATAEGUS_SP"}
\item \code{"PRUNUS_SP"},
\item \code{"CARPINUS_SP"},
\item \code{"CASTANEA_SATIVA"},
\item \code{"CORYLUS_AVELLANA"},
\item \code{"MALUS_SP"}
\item \code{"PYRUS_SP"},
\item \code{"SORBUS_ARIA"},
\item \code{"SAMBUCUS_SP"},
\item \code{"RHAMNUS_FRANGULA"},
\item \code{"PRUNUS_CERASUS"}
\item \code{"ALNUS_INCANA"},
\item \code{"POPULUSxCANADENSIS"},
\item \code{"POPULUS_TREMULA"},
\item \code{"PINUS_NIGRA"},
\item \code{"PINUS_LARICIO"}
\item \code{"TAXUS_BACCATA"},
\item \code{"ACER_PLATANOIDES"},
\item \code{"ACER_CAMPESTRE"},
\item \code{"SORBUS_AUCUPARIA"},
\item \code{"JUNGLANS_SP"}
\item \code{"TILLIA_SP"},
\item \code{"AESCULUS_HIPPOCASTANUM"},
\item \code{"ROBINIA_PSEUDOACACIA"},
\item \code{"SALIX_SP"}
}
}

\examples{
df <- data.frame(
  c130         = c(145, 156, 234, 233),
  species_code = c("PINUS_SYLVESTRIS", "QUERCUS_RUBRA",
                   "QUERCUS_SP", "FAGUS_SYLVATICA")
)
dagnelie_br(df)
}
\seealso{
\code{\link{danbr}} for species-specific coefficients.
}
