% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dagnelie_vc22_1g.R
\name{dagnelie_vc22_1g}
\alias{dagnelie_vc22_1g}
\title{Graduated single-entry Dagnelie volume (tarif 1g)}
\usage{
dagnelie_vc22_1g(data, output = NULL)
}
\arguments{
\item{data}{A \code{data.frame} containing the columns:
\itemize{
\item \code{c130} (stem circumference at 1.30 m, in cm)
\item \code{hdom} (dominant height, in m)
\item \code{species_code} (character code of the tree species)
}}

\item{output}{Optional file path where the resulting data frame should be
exported as a CSV. If \code{NULL} (default), no file is written.
Export is handled by the utility function \code{export_output()}.}
}
\value{
A \code{data.frame} identical to \code{data}, augmented with:
\itemize{
\item the joined columns from \code{dan1g}
(\code{coeff_a}, \code{coeff_b}, \code{coeff_c}, \code{coeff_d},
\code{coeff_e}, \code{coeff_f},
\code{min_c130}, \code{max_c130}, \code{min_hdom}, \code{max_hdom})
\item \code{dagnelie_vc22_1g}: the computed volume (m\eqn{^3} per tree)
}
}
\description{
Computes the standing volume \eqn{v_{c,22}} (in cubic metres per tree) using
Dagnelie's \emph{tarif 1g} equations. The volume is calculated from the stem
circumference at 1.30 m (\code{c130}, in cm), the dominant height
(\code{hdom}, in m), and the tree species, using species-specific polynomial
coefficients stored in \code{dan1g}.
}
\details{
The function:
\itemize{
\item checks that the input data frame contains the required columns
\code{c130}, \code{hdom} and \code{species_code},

\item validates that all species codes are present in the \code{dan1g} table,

\item merges the input data with \code{dan1g} to retrieve:
\code{coeff_a}, \code{coeff_b}, \code{coeff_c}, \code{coeff_d},
\code{coeff_e}, \code{coeff_f},
as well as the species-specific valid ranges
\code{min_c130}, \code{max_c130}, \code{min_hdom}, \code{max_hdom},

\item issues a warning for trees whose \code{c130} is outside the valid
range \code{[min_c130, max_c130]},

\item issues a warning for trees whose \code{hdom} is outside the valid
range \code{[min_hdom, max_hdom]},

\item computes the tarif 1g volume using the species-specific polynomial:
\deqn{
           v_{c,22} =
           coeff_a +
           coeff_b \cdot c130 +
           coeff_c \cdot c130^2 +
           coeff_d \cdot c130^3 +
           coeff_e \cdot hdom +
           coeff_f \cdot c130^2 \cdot hdom
        }
}

Species codes must match those available in the \code{dan1g} table.
If one or more species are not found, the function issues a warning.

If a tree's \code{c130} or \code{hdom} falls outside the species-specific
validity ranges \code{[min_c130, max_c130]} or \code{[min_hdom, max_hdom]},
a warning is issued, but the volume is still computed.
}
\examples{
df <- data.frame(
  c130         = c(145, 156, 234, 233),
  hdom         = c(25, 23, 45, 34),
  species_code = c("PINUS_SYLVESTRIS", "QUERCUS_RUBRA",
                   "QUERCUS_SP", "FAGUS_SYLVATICA")
)
dagnelie_vc22_1g(data = df)
}
\seealso{
\code{\link{dan1g}} for the species-specific coefficients and ranges.
}
