% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{aggregate_cases}
\alias{aggregate_cases}
\title{Aggregate cases}
\usage{
aggregate_cases(
  data = NULL,
  cases = NULL,
  pop = NULL,
  time = NULL,
  area = NULL,
  pt = 1e+05,
  aggregate_space = NULL,
  aggregate_time = NULL
)
}
\arguments{
\item{data}{Data frame containing equally spaced
(daily, weekly, monthly) incident cases for one or multiple areas.}

\item{cases}{Name of the variable that identifies the cases.}

\item{pop}{Name of the variable that identifies the population.}

\item{time}{Name of the variable that identifies the temporal dimension.
The values must be in date format ("yyyy-mm-dd")
representing the day of observation for daily data, the first day of the
week for weekly, or the first day of the month for monthly observations.}

\item{area}{Name of variable that identifies the different locations
(e.g., areal units) for which a time series is available.}

\item{pt}{Scale of the person-time (default 100,000) for incidence rates.}

\item{aggregate_space}{Name of variable used to define spatial
aggregation groups.}

\item{aggregate_time}{Temporal scale used to perform
temporal aggregation. Options are: "week" (ISO 8601), "month", "year".}
}
\value{
A data frame with the aggregated cases.
}
\description{
Aggregates a data frame containing disease cases in space and/or
time.
}
