% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/imputation.R
\name{impute}
\alias{impute}
\title{Multiple imputation}
\usage{
impute(missbp, imp.method = c("MIMCA", "jomo", "DPMPM", "mice"), m = 5)
}
\arguments{
\item{missbp}{An object of class \code{missmi} obtained from preceding function \code{missmi()}.}

\item{imp.method}{Select one of four imputation methods: \code{MIMCA}, \code{jomo}, \code{DPMPM}, \code{mice}}

\item{m}{Number of multiple imputations}
}
\value{
The \code{missbp} object is appended with the following object:
\item{dataimp}{List of imputed data}

See also \code{\link[missMDA]{MIMCA}}, \code{\link[jomo]{jomo1cat}} and \code{\link[mi]{mi}} and \code{\link[mice]{mice}}.
}
\description{
Choose between four available multiple imputation strategies in \code{R}.
}
\examples{
\donttest{
data(missdat)
missbp <- missmi(missdat) |> impute(imp.method="DPMPM", m=5)}

}
