% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flex_correlation_plot.R
\name{flex_correlation_plot}
\alias{flex_correlation_plot}
\title{flex_correlation_plot function}
\usage{
flex_correlation_plot(
  correlation_matrix,
  user_colors = c("darkred", "white", "steelblue4"),
  display_names = TRUE,
  interactive = TRUE,
  user_lower_limit = -1,
  user_upper_limit = 1,
  user_mid_point = 0,
  user_plotly_x_name = "VAR_A",
  user_plotly_y_name = "VAR_B",
  user_plotly_value_name = "r",
  user_title = "Correlation Plot",
  user_x_title = NULL,
  user_y_title = NULL,
  user_legend_title = "Correlation",
  matrix_type = "full",
  user_plot_theme = theme_minimal(),
  user_plot_theme_specs = theme(legend.title = element_text(size = 10), legend.text =
    element_text(size = 10), title = element_text(size = 15), axis.text.x =
    element_text(size = 10), axis.title.x = element_text(size = 10), axis.text.y =
    element_text(size = 10), axis.title.y = element_text(size = 10)),
  user_zoom_range = NULL
)
}
\arguments{
\item{correlation_matrix}{A square matrix representing correlation coefficients
with column names identical to row names.}

\item{user_colors}{A vector of three colors representing the gradient of the
heatmap for negative, neutral, and positive correlations respectively.
Default is c("darkred", "white", "steelblue4").}

\item{display_names}{Logical, whether to display variable names on the axes.
Default is TRUE.}

\item{interactive}{Logical, indicating if the output should be an interactive
plotly object. Default is TRUE.}

\item{user_lower_limit}{The minimum value of the color gradient. Default is -1.}

\item{user_upper_limit}{The maximum value of the color gradient. Default is 1.}

\item{user_mid_point}{The midpoint value of the color gradient where the neutral
color is centered. Default is 0.}

\item{user_plotly_x_name}{The name to be used for the x-axis in the plotly plot.
Default is "VAR_A".}

\item{user_plotly_y_name}{The name to be used for the y-axis in the plotly plot.
Default is "VAR_B".}

\item{user_plotly_value_name}{The name to be used for the values in the plotly
tooltip. Default is "r".}

\item{user_title}{Title of the heatmap. Default is "Correlation Plot".}

\item{user_x_title}{Custom x-axis title. If NULL, defaults to column names of
the matrix.}

\item{user_y_title}{Custom y-axis title. If NULL, defaults to row names of the
matrix.}

\item{user_legend_title}{Title for the legend. Default is "Correlation".}

\item{matrix_type}{Specifies whether to plot the full matrix, the lower triangular
part, or the upper triangular part. Default options are "full", "lower", "upper".}

\item{user_plot_theme}{ggplot2 theme object for base theming of the plot. Default
is theme_minimal().}

\item{user_plot_theme_specs}{Additional ggplot2 theme specifications to apply
on top of \code{user_plot_theme}.}

\item{user_zoom_range}{Optional numeric vector specifying the indices of the
matrix to zoom into; this disables interactivity.}
}
\value{
A ggplot object if \code{interactive = FALSE}, otherwise a plotly interactive plot.
}
\description{
This function creates a correlation heatmap using ggplot2 and plotly, allowing
for various customizations. It supports rendering both static and interactive
correlation heatmaps of either the full, lower, or upper triangular matrix.
}
\examples{
library(ggplot2)
library(plotly)
library(dplyr)
library(nortest)
library(ggforce)
library(reshape2)
library(gridExtra)
library(grid)
library(cowplot)
# Generate a symmetric correlation matrix
correlation_matrix <- example_data9
# Default full matrix heatmap
flex_correlation_plot(correlation_matrix)

# Lower triangular heatmap
flex_correlation_plot(correlation_matrix, matrix_type = "lower")

# Customized plot with different theme and colors
flex_correlation_plot(
  correlation_matrix = correlation_matrix,
  user_colors = c("gold2", "lightgrey", "darkblue"),
  user_title = "Custom Correlation Plot",
  user_x_title = "Variables",
  user_y_title = "Variables",
  user_legend_title = "Correlation Coefficient",
  user_plot_theme = theme_classic(),
  user_plot_theme_specs = theme(
    legend.title = element_text(size = 12),
    legend.text = element_text(size = 10),
    title = element_text(size = 16),
    axis.title.x = element_text(size = 12),
    axis.text.x = element_text(size = 12, angle = 45, hjust = 1),
    axis.text.y = element_text(size = 12),
    axis.title.y = element_text(size = 12),
    legend.position = "bottom")
)
}
