% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GRAB_Marker.R
\name{GRAB.Marker}
\alias{GRAB.Marker}
\title{Perform single-marker association tests using a fitted null model}
\usage{
GRAB.Marker(
  objNull,
  GenoFile,
  OutputFile,
  GenoFileIndex = NULL,
  OutputFileIndex = NULL,
  control = NULL
)
}
\arguments{
\item{objNull}{(S3 object) Null model object from \code{\link{GRAB.NullModel}},
\code{\link{SPAGRM.NullModel}} or \code{\link{SAGELD.NullModel}}. Supported classes:
\itemize{
\item \code{POLMM_NULL_Model}: See \code{?\link{GRAB.POLMM}}.
\item \code{SPACox_NULL_Model}: See \code{?\link{GRAB.SPACox}}.
\item \code{SPAmix_NULL_Model}: See \code{?\link{GRAB.SPAmix}}.
\item \code{WtCoxG_NULL_Model}: See \code{?\link{GRAB.WtCoxG}}.
\item \code{SPAGRM_NULL_Model}: See \code{?\link{GRAB.SPAGRM}}.
\item \code{SAGELD_NULL_Model}: See \code{?\link{GRAB.SAGELD}}.
}}

\item{GenoFile}{Path to genotype file. Supported formats determined by extension:
\itemize{
\item PLINK: "prefix.bed"
\item BGEN: "prefix.bgen" (version 1.2 with 8-bit compression)
}}

\item{OutputFile}{(character) Path for saving association test results.}

\item{GenoFileIndex}{(character vector or NULL) Associated files for the genotype file (auto-detected if NULL):
\itemize{
\item PLINK: c("prefix.bim", "prefix.fam")
\item BGEN: c("prefix.bgen.bgi", "prefix.sample") or c("prefix.bgen.bgi")
}}

\item{OutputFileIndex}{(character or NULL) #' Path to the progress tracking file from a previous unfinished run.
Enables analysis to restart if interrupted. If \code{NULL} (default), uses \code{paste0(OutputFile, ".index")}.}

\item{control}{(list or NULL) List of control parameters with the following elements:
\itemize{
\item \code{AlleleOrder} (character or NULL): Allele order in genotype file. Options: "ref-first",
"alt-first", or NULL (default: "alt-first" for BGEN, "ref-first" for PLINK).
\item \strong{Marker Selection:}
\itemize{
\item \code{AllMarkers} (logical): Set to TRUE (default) to analyze all markers. Automatically
set to FALSE if any include/exclude files are provided.
\item \code{IDsToIncludeFile} (character or NULL): Path to file with marker IDs to include.
\item \code{RangesToIncludeFile} (character or NULL): Path to file with genomic ranges to include.
Can be used with IDsToIncludeFile (union will be used).
\item \code{IDsToExcludeFile} (character or NULL): Path to file with marker IDs to exclude.
\item \code{RangesToExcludeFile} (character or NULL): Path to file with genomic ranges to exclude.
Can be used with IDsToExcludeFile (union will be excluded).
\item Note: Cannot use both include and exclude files simultaneously.
}
\item \code{impute_method} (character): Imputation method for handling missing genotypes
during analysis in C++ backend. Applies to all genotype formats. Options: "mean" (default), "minor", "drop".
\item \code{missing_cutoff} (numeric): Exclude markers with missing rate above this threshold.
Range: 0 to 0.5. Default: 0.15.
\item \code{min_maf_marker} (numeric): Exclude markers with MAF below this threshold.
Range: 0 to 0.1. Default: 0.001.
\item \code{min_mac_marker} (numeric): Exclude markers with MAC below this threshold.
Range: 0 to 100. Default: 20.
\item \code{nMarkersEachChunk} (integer): Number of markers processed per chunk.
Range: 1000 to 100000. Default: 10000.
\item \code{SPA_Cutoff} (numeric): Z-score cutoff for saddlepoint approximation. When the absolute
value of the test statistic exceeds this cutoff, SPA is used to calculate more accurate p-values. Default: 2.
}}
}
\value{
The function returns \code{NULL} invisibly. Results are written to \code{OutputFile}.
For method-specific examples and output columns and format, see:
\itemize{
\item POLMM method: \code{\link{GRAB.POLMM}}
\item SPACox method: \code{\link{GRAB.SPACox}}
\item SPAmix method: \code{\link{GRAB.SPAmix}}
\item WtCoxG method: \code{\link{GRAB.WtCoxG}}
\item SPAGRM method: \code{\link{GRAB.SPAGRM}}
\item SAGELD method: \code{\link{GRAB.SAGELD}}
}
}
\description{
Conducts single-marker association tests between genetic variants and phenotypes using
various statistical methods supported by GRAB.
}
