% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SPACox.R
\name{fitNullModel.SPACox}
\alias{fitNullModel.SPACox}
\title{Fit SPACox null model from survival outcomes or residuals}
\usage{
fitNullModel.SPACox(response, designMat, subjData, control, ...)
}
\arguments{
\item{response}{Either a \code{survival::Surv} object (time-to-event) or a
numeric residual vector with class \code{"Residual"}.}

\item{designMat}{Numeric design matrix (n x p) of covariates.}

\item{subjData}{Vector of subject IDs aligned with rows of \code{designMat}.}

\item{control}{List with fields such as \code{range} and \code{length.out}
for the CGF grid.}

\item{...}{Extra arguments passed to \code{survival::coxph} when
\code{response} is \code{Surv}.}
}
\value{
A list of class \code{"SPACox_NULL_Model"} with elements:
\describe{
\item{N}{Number of subjects.}
\item{mresid}{Martingale residuals (numeric vector).}
\item{cumul}{CGF grid as a matrix with columns t, K0, K1, K2.}
\item{tX}{Transpose of design matrix with intercept (p+1 x n).}
\item{yVec}{Status/event indicator or residual-based response.}
\item{X.invXX}{Projection helper: X \%\emph{\% solve(t(X) \%}\% X).}
\item{subjData}{Character vector of subject IDs.}
}
}
\description{
Computes martingale residuals (or uses provided residuals) and an empirical
cumulant generating function (CGF) for SPA-based single-variant tests.
}
\keyword{internal}
