#' Degree Calculation for Random Circular Graph
#'
#' Computes the degree of each vertex in a Random Circular Graph based on input arcs.
#'
#' @param theta A numeric vector of length m=2*nv.
#' @return A vector of degrees for each vertex of RCAG obtained using theta.
#' @examples
#' x <- arima.sim(model = list(ar=0.9), 1000) ## AR(1) model
#' theta <- ((2*atan(x))%%(2*pi))*(180/pi) ##LAR(1) model
#' deg.rcag(theta)
#' @export
deg.rcag <- function(theta) {
  nv <- length(theta) %/% 2
  start <- c()
  end <- c()
  m <- matrix(0, nrow = nv, ncol = nv)
  for (i in 1:nv) {
    start[i] <- theta[2*i - 1]
    end[i] <- theta[2*i]
  }
  for (i in 1:(nv-1)) {
    for (j in (i+1):nv) {
      if (start[i] < end[i] && end[i] < start[j] && start[j] < end[j]) {
        m[i, j] <- 0
        m[j, i] <- 0
      } else if (end[j] < start[i] && start[i] < end[i] && end[i] < start[j]) {
        m[i, j] <- 0
        m[j, i] <- 0
      } else if (start[j] < end[j] && end[j] < start[i] && start[i] < end[i]) {
        m[i, j] <- 0
        m[j, i] <- 0
      } else if (end[i] < start[j] && start[j] < end[j] && end[j] < start[i]) {
        m[i, j] <- 0
        m[j, i] <- 0
      } else {
        m[i, j] <- 1
        m[j, i] <- 1
      }
    }
  }
  deg <- rowSums(m)
  return(deg)
}
