#' Threshold for RIG-DD Test of randomness
#'
#' Calculates a threshold for RIG-DD test using simulated data.
#'
#' @param m Number of observations.
#' @param n_iter Number of simulation iterations.
#' @param alpha Level of significance.
#' @return Threshold value for RIG-DD test.
#' @examples
#' thrsd.rigdd(250,1000,0.05)
#' @export
thrsd.rigdd <- function(m, n_iter, alpha) {
  nv <- m %/% 2
  cdf_H <- numeric(n_iter)
  cdf_t <- cdf.rig(m)
  for (i in 1:n_iter) {
    x <- runif(2 * nv, 0, 1)
    deg <- deg.rig(x)
    cdf <- sapply(1:nv, function(j) sum(deg <= j) / nv)
    cdf_H[i] <- hellinger.dist(cdf, cdf_t)
  }
  cutoff <- quantile(cdf_H, 1-alpha)
  return(cutoff)
}
