% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/identify_outliers.R
\name{identify_outliers}
\alias{identify_outliers}
\title{Identifies outliers in a numeric vector}
\usage{
identify_outliers(
  x,
  probabilities = c(0.25, 0.75),
  method = "iqr",
  weight = 1.5,
  replace = FALSE
)
}
\arguments{
\item{x}{Vector containing numerical values.}

\item{probabilities}{Numeric vector specifying probabilities for percentiles.}

\item{method}{Character specifying the method: \code{iqr}, \code{percentiles}, \code{hampel}, \code{mad}, or \code{sd}.}

\item{weight}{Double specifying the multiplier for the detection threshold.}

\item{replace}{Logical specifying whether to replace outliers with \code{NA}.}
}
\value{
A numeric vector whose content depends on the value of \code{replace}:
\describe{
\item{replace = FALSE}{A numeric vector containing only the detected outlier
values. The vector is named with the original indices or names of \code{x}.}
\item{replace = TRUE}{A numeric vector of the same length as \code{x}, where
detected outliers are replaced by \code{NA}.}
}
}
\description{
Detects outliers using methods like IQR, percentiles, Hampel, MAD, or SD.
}
\examples{
x <- rnorm(100)
identify_outliers(x, method = "iqr")
identify_outliers(x, method = "percentiles", probabilities = c(0.1, 0.9))
identify_outliers(x, method = "sd", weight = 3)
identify_outliers(x, method = "mad", replace = TRUE)

}
