% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print_dispersion.R
\name{print_dispersion}
\alias{print_dispersion}
\title{Prints the dispersion of a numeric vector}
\usage{
print_dispersion(x, digits = 1, width = 15, method = "median")
}
\arguments{
\item{x}{Vector containing numerical values.}

\item{digits}{Integer specifying the number of decimal places for the test
statistic.}

\item{width}{Integer specifying the maximum width for wrapping text.}

\item{method}{Character specifying the method: \code{median} for median and IQR, or \code{mean} for mean and SD.}
}
\value{
A character string containing a measure of central tendency and
dispersion. Depending on \code{method}, this is either the median and
interquartile range or the mean and standard deviation.
}
\description{
Calculates and prints the median and interquartile range (IQR) or the mean and standard deviation (SD).
}
\examples{
print_dispersion(runif(10))
print_dispersion(runif(10), method = "mean", digits = 2, width = 5)

}
