% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary_statistics.R
\name{print_numeric}
\alias{print_numeric}
\title{Prints descriptive statistics for numeric variables}
\usage{
print_numeric(x, digits = 1, width = 15)
}
\arguments{
\item{x}{Data frame, matrix, or vector containing numerical variables.}

\item{digits}{Integer specifying the number of decimal places for the test
statistic.}

\item{width}{Integer specifying the maximum width for wrapping text.}
}
\value{
A tibble with one row per numeric variable and the following columns:
\describe{
\item{Variables}{Character specifying the variable name.}
\item{Mean+/-SD}{Character specifying the mean and standard deviation.}
\item{Median+/-IQR}{Character specifying the median and interquartile range.}
\item{Q1-Q3}{Character specifying the first and third quartiles.}
\item{Range}{Character specifying the minimum and maximum values.}
\item{Kurtosis}{Numeric specifying the kurtosis coefficient.}
\item{Skewness}{Numeric specifying the skewness coefficient.}
\item{Normality}{Character specifying the Shapiro-Wilk normality test significance code.}
\item{Zeros}{Integer specifying the number of zero values.}
\item{NAs}{Integer specifying the number of missing values.}
}
}
\description{
Prints summary statistics (mean, median, quartiles, range, etc.) for numeric variables.
}
\examples{
x <- data.frame(A = rnorm(100), B = rnorm(100))
print_numeric(x)
print_numeric(x, digits = 2, width = 5)

}
