% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print_test.R
\name{print_test}
\alias{print_test}
\title{Prints a hypothesis test}
\usage{
print_test(x, digits = 0, digits_p = 2)
}
\arguments{
\item{x}{Test object from \code{rstatix} among \code{anova_test}, \code{kruskal_test}, or
\code{wilcox_test}.}

\item{digits}{Integer specifying the number of decimal places for the test
statistic.}

\item{digits_p}{Integer specifying the number of decimal places for the
p-value.}
}
\value{
A character string containing the formatted test results with:
\describe{
\item{Test name}{Name of the statistical test (ANOVA, Kruskal-Wallis, Wilcoxon,
t-test, Friedman, or mixed-effects model).}
\item{Test statistic}{Test statistic (F, K, W, T, or \eqn{\chi^2})
with degrees of freedom when applicable.}
\item{P-value}{P-value with significance stars.}
}
}
\description{
Formats the results of a hypothesis test (ANOVA, Kruskal-Wallis, or Wilcoxon).
}
\examples{
library(rstatix)
data("ToothGrowth")
res <- anova_test(ToothGrowth, len ~ dose)
print_test(res)

res <- kruskal_test(ToothGrowth, len ~ dose)
print_test(res)

res <- wilcox_test(ToothGrowth, len ~ supp)
print_test(res)

library(lmerTest)
data("sleepstudy", package = "lme4")
res <- lmer(Reaction ~ Days + (Days | Subject), sleepstudy)
print_test(res)

}
