% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_repos.R
\name{get_repos_trees}
\alias{get_repos_trees}
\title{Get data on files trees across repositories}
\usage{
get_repos_trees(
  gitstats,
  pattern = NULL,
  depth = Inf,
  cache = TRUE,
  verbose = FALSE,
  progress = TRUE
)
}
\arguments{
\item{gitstats}{A GitStats object.}

\item{pattern}{A regular expression. If defined, it pulls structure of files
in a repository matching this pattern reaching to the level of directories
defined by \code{depth} parameter.}

\item{depth}{Defines level of directories to reach for files structure from.
E.g. if set to \code{0}, it will pull files tree only from \code{root}, if \code{1L}, will
take data from \code{root} directory and directories visible in \code{root}
directory. If left with no argument, will pull files tree down to every
directory in a repo.}

\item{cache}{A logical, if set to \code{TRUE} GitStats will retrieve the last
result from its storage.}

\item{verbose}{A logical, \code{TRUE} by default. If \code{FALSE} messages and printing
output is switched off.}

\item{progress}{A logical, by default set to \code{verbose} value. If \code{FALSE} no
\code{cli} progress bar will be displayed.}
}
\value{
A \code{tibble}.
}
\description{
Pulls files tree (structure) per repository. Files trees are
then stored as character vectors in \code{files_tree} column of output table.
}
\examples{
\dontrun{
 my_gitstats <- create_gitstats() |>
  set_github_host(
    token = Sys.getenv("GITHUB_PAT"),
    orgs = c("r-world-devs", "openpharma")
  )

 get_repos_trees(
   gitstats = my_gitstats,
   pattern = "\\\\.md"
 )
}
}
