\name{get_bmu_gower}
\alias{get_bmu_gower}
\title{Map observations to BMUs (Best Matching Units) using Gower distance}
\description{
Computes, for each observation, the index of the best-matching neuron (BMU)
in a trained Gower-SOM codebook and the corresponding Gower distance.
Also converts BMU indices into grid coordinates (row, col).
}
\usage{
get_bmu_gower(data, codebook, n_rows, n_cols)
}
\arguments{
  \item{data}{A \code{data.frame} of observations to map. Must be typed consistently
    with the training data (numeric, factor, etc.).}
  \item{codebook}{A \code{data.frame} (or coercible matrix) with one row per neuron
    and the same columns as \code{data}.}
  \item{n_rows, n_cols}{Integers, the SOM grid dimensions.}
}
\value{
A \code{data.frame} with the following columns:
\describe{
  \item{bmu}{Integer BMU index (1 .. n_rows * n_cols).}
  \item{distance}{Numeric, the Gower distance to the BMU.}
  \item{row}{Integer, BMU grid row coordinate.}
  \item{col}{Integer, BMU grid column coordinate.}
}
}
\author{
  Patricio Sáez <patricsaez@udec.cl>;
  Patricio Salas <patricioasalas@udec.cl>
}

\references{
Sáez, P., Salas, P. Gower-SOM: a self-organizing map for mixed data with gower distance and heuristic adaptation for data analytics. Int J Data Sci Anal 22, 26 (2026). https://doi.org/10.1007/s41060-025-00941-6/."
}

\examples{
set.seed(1)
df <- data.frame(
  x1 = rnorm(10),
  x2 = rnorm(10),
  g  = factor(sample(letters[1:3], 10, TRUE))
)
fit <- gsom_Training(df, grid_rows = 3, grid_cols = 3,
                num_iterations = 5, batch_size = 5)
res <- get_bmu_gower(df, codebook = fit$weights,
                     n_rows = 3, n_cols = 3)
head(res)
}
\seealso{\code{\link{gsom_predict}}}
