% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hcup_citation.R
\name{hcup_citation}
\alias{hcup_citation}
\title{Generate Citation for HCUP Resources}
\usage{
hcup_citation(format = "text", version = "latest", resource = "ccsr")
}
\arguments{
\item{format}{Character string specifying the citation format. Must be one
of: "text" (default), "bibtex", or "r" (for R citation object).}

\item{version}{Character string specifying the CCSR version to cite. If
"latest" (default), the function will attempt to fetch the latest version
from the HCUP website. Otherwise, specify a version like "v2026.1".}

\item{resource}{Character string specifying which HCUP resource to cite.
Options: "ccsr" (default) for CCSR data, or "trend_tables" for Summary
Trend Tables.}
}
\value{
If \code{format} is "text", returns a character string with the citation.
If \code{format} is "bibtex", returns a character string with BibTeX format.
If \code{format} is "r", returns an R citation object.
}
\description{
Provides recommended citations for HCUP resources including Clinical
Classifications Software Refined (CCSR) data and Summary Trend Tables from
the Agency for Healthcare Research and Quality (AHRQ) Healthcare Cost and
Utilization Project (HCUP).
}
\details{
This function generates citations for HCUP resources following AHRQ/HCUP
guidelines. The citation includes the appropriate version number and
access date. For CCSR data, the version is automatically detected if not
specified. For Summary Trend Tables, the citation references the general
HCUP Summary Trend Tables resource.
}
\examples{
# Text citation for CCSR
hcup_citation()

# BibTeX format for CCSR
hcup_citation(format = "bibtex")

# Citation for Summary Trend Tables
hcup_citation(resource = "trend_tables")

# R citation object
hcup_citation(format = "r")

}
