% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{update_without_factor}
\alias{update_without_factor}
\title{Update a Model without Factor}
\usage{
update_without_factor(model, fac, hierarchical = TRUE)
}
\arguments{
\item{model}{\code{model} object to update.}

\item{fac}{\code{character} factor to remove.}

\item{hierarchical}{\code{logical} obey hierarchy when removing factor (default = TRUE).}
}
\value{
An updated model object is returned. If the supplied model is of
type \code{lmerMod} and no random effects are left, the model is
automatically converted to a linear model before updating.
}
\description{
Perform a model update while removing a chosen factor. Hierarchical
corresponds to type "II" sum-of-squares, i.e., obeying marginality,
while non-hierarchical corresponds to type "III" sum-of-squares.
}
