% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HGDM.R
\name{HGDM}
\alias{HGDM}
\title{Applies HGDM to forcings}
\usage{
HGDM(
  upland_area = NULL,
  small_depression_area = NULL,
  large_depression_area = NULL,
  area_units = "km2",
  max_small_depression_storage = 0,
  max_large_depression_storage = 0,
  initial_small_depression_storage = 0,
  initial_large_depression_storage = 0,
  storage_units = "mm",
  small_depressions_initial_connected_fraction = 0,
  upland_fraction_to_small = 0,
  upland_fraction_to_large = 0,
  upland_fraction_to_outlet = 0,
  small_fraction_to_large = 0,
  forcings = NULL,
  small_p = NULL,
  large_rating = 0,
  sub_intervals = 1
)
}
\arguments{
\item{upland_area}{Required. Area of uplands, which drain to the outlet, 
small depressions or the large depression.}

\item{small_depression_area}{Required. Area of small depressions.}

\item{large_depression_area}{Optional. If \code{0} or \code{NULL} large depression is not \
modelled.}

\item{area_units}{Units of all areas. Must be one of \option{km2} (default), \option{ha} or \option{m2}.}

\item{max_small_depression_storage}{Maximum depth of storage in small depressions.}

\item{max_large_depression_storage}{Maximum depth of storage in large depressions.}

\item{initial_small_depression_storage}{Initial depth of storage in small depressions.}

\item{initial_large_depression_storage}{Initial depth of storage in large depressions.}

\item{storage_units}{Units of all storage depths. Must be one of \option{mm} (default) \option{m},
or \option{m3}. If a depth is specified then it will be converted to a volume by multiplying
by the appropriate area.}

\item{small_depressions_initial_connected_fraction}{Initial connected fraction (0-1).}

\item{upland_fraction_to_small}{Fraction of uplands draining to small depressions. If \code{0} then
the small depressions are unlikely to fill.}

\item{upland_fraction_to_large}{Fraction of uplands draining to large depression. This is
the basin of the large depression.}

\item{upland_fraction_to_outlet}{Fraction of uplands draining directly to outlet. Analogous
to the effective fraction.}

\item{small_fraction_to_large}{Fraction of small depression area draining into large depression.
Governed by location of large depression in the basin.}

\item{forcings}{Required. A data frame of time series of \code{rainfall}, \code{snowmelt},
\code{evap}, and \code{runoff}. The first variable must be either \code{date} (an
\pkg{R} date) or \code{datetime} (a POSIXct date-time).}

\item{small_p}{Parameter for small depression water volume-area relationship.}

\item{large_rating}{Rating curve parameters for large depression.}

\item{sub_intervals}{Number of sub-intervals for solution of each time step.}
}
\value{
Returns a data frame. Depending on whether or not a large depression was
specified, the data frame will have differing variables. Note that regardless of the 
units specified for areas and volumes, all of the variables returned are in SI
dimensions, i.e. `m` and `m\eqn{^3}{^3}/s`
values

If no large depression is specified, the returned variables are:

\describe{
\item{date or datetime}{\R date or POSIXct datetime.}
\item{total_contrib_frac}{The connected/contributing fraction of the basin. Includes both the meta depression and the upland fraction connected to the outlet.}
\item{total_outflow_volume}{The volume of outflow (m \eqn{^3}{^3}) in the interval.}
\item{small_depression_contrib_frac}{The connected/contributing fraction of the meta depression.}
\item{small_depression_water_volume}{The volume of water (m \eqn{^3}{^3}) retained in the meta depression.}
\item{small_depression_water_depth}{The depth of water (m) retained in the meta depression.}
\item{small_depression_water_area}{The area of water (m  \eqn{^2}{^2}) retained in the meta depression.}
}

If there is a large depression, then `total_contrib_frac` includes the effect of the large
depression and the additional variables are also returned:

\describe{
\item{date or datetime}{\R date or POSIXct datetime.}
\item{large_depression_contrib_frac}{The connected/contributing fraction of the large depression.}
\item{large_depression_water_volume}{The volume of water (m \eqn{^3}{^3}) retained in the large depression.}
\item{large_depression_water_area}{The area of water (m  \eqn{^2}{^2}) retained in the large depression.}
}
}
\description{
Applies the Hysteretic and Gatekeeping Depressions Model to basin-scale fluxes determined
by hydrological modelling to calculate the outflows during a given time interval. Note
than no routing is performed.
}
\examples{
{ 
daily_fluxes <- daily_7120951600  
basin_area <- 100
small_depression_frac <- 0.24
small_depression_area <- small_depression_frac * basin_area
large_depression_area <- 0
upland_area <- basin_area - (small_depression_area + large_depression_area)
area_units <- "km2"
max_small_depression_storage <- 300
max_large_depression_storage <- 0
initial_small_depression_storage <- max_small_depression_storage / 2
initial_large_depression_storage <- max_large_depression_storage / 2
storage_units <- "mm"
small_depressions_initial_connected_fraction <- 0
upland_fraction_to_small <- 0.98
upland_fraction_to_large <- 0
upland_fraction_to_outlet <- 0.02
small_fraction_to_large <- 0
small_p <- 1.2
large_rating <- 1.4
sub_intervals <- 1

results <- HGDM(upland_area, 
small_depression_area, 
large_depression_area = 0, 
area_units = "km2", max_small_depression_storage, 
max_large_depression_storage,
initial_small_depression_storage, 
initial_large_depression_storage,
storage_units,
small_depressions_initial_connected_fraction,
upland_fraction_to_small,
upland_fraction_to_large,
upland_fraction_to_outlet,
small_fraction_to_large,
forcings = daily_fluxes[1:100,],
small_p = small_p,
large_rating = large_rating,
sub_intervals = sub_intervals)
}
}
