HMMVarianceMatrix <- function(x, HMM, obsdist, h = 1e-5, method = "central", verbose = TRUE) {
  # Convert HMM to equivalent HSMM structure
  HSMM <- list()
  # Extract observation parameters (excludes Pi and delta)
  HSMM$observationparameters <- HMM$estimate[1:(length(HMM$estimate) - 2)]
  # Set geometric dwell parameters from transition probabilities
  HSMM$dwellparameters <- list()
  HSMM$dwellparameters$prob <- 1 - diag(HMM$estimate$Pi)  # P(leave state)
  # Create HSMM transition matrix (no self-transitions)
  HSMM$Pi <- HMM$estimate$Pi
  diag(HSMM$Pi) <- 0
  # Copy initial state probabilities
  HSMM$delta <- HMM$estimate$delta
  J <- length(HSMM$delta)
  # Compute full variance-covariance matrix using HSMM framework
  var_cov <- HSMMVarianceMatrix(x, HSMM, obsdist = obsdist, dwelldist = "geom",
                                h = h, method = method, verbose = verbose)
  # Extract only observation parameter portion
  obs_param_count <- length(HSMM$observationparameters)
  var_cov <- var_cov[1:(J * obs_param_count), 1:(J * obs_param_count)]
  return(var_cov)
}
