% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HPZone_necessary_scope.R
\name{HPZone_necessary_scope}
\alias{HPZone_necessary_scope}
\title{Determines the necessary scope for a given list of fields.}
\usage{
HPZone_necessary_scope(fields, endpoint = "Cases", resolve_fieldnames = TRUE)
}
\arguments{
\item{fields}{List of desired fields from a query.}

\item{endpoint}{The required endpoint.}

\item{resolve_fieldnames}{Whether or not to parse the supplied fields and convert them to valid HPZone field names. (By calling [HPZone_make_valid])}
}
\value{
The required scope as expected by the HPZone API, i.e. "standard" or "extended".
}
\description{
Determines the necessary scope for a given list of fields.
}
\examples{
# these variables do not required an extended scope; desired response = standard
HPZone_necessary_scope(c("Diagnosis", "Case_number", "Entered_by"))
# Family_name requires the extended scope; desired response = extended
HPZone_necessary_scope(c("Diagnosis", "Case_number", "Family_name"))
}
