% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bcbcsf.r
\name{bcbcsf_deltas}
\alias{bcbcsf_deltas}
\title{Bias-corrected Bayesian classification initial state}
\usage{
bcbcsf_deltas(X, y, alpha = 0)
}
\arguments{
\item{X}{Design matrix of traning data; 
rows should be for the cases, and columns for different features.}

\item{y}{Vector of class labels in training or test data set. 
Must be coded as non-negative integers, e.g., 1,2,\ldots,C for C classes.}

\item{alpha}{The regularization proportion (between 0 and 1) for mixing the 
diagonal covariance estimates and the sample covariance estimated with the 
training samples. The default is 0, the covariance matrix is assumed to be diagonal, 
which is the most robust.}
}
\value{
A matrix - the initial state of Markov Chain for HTLR model fitting.
}
\description{
Generate initial Markov chain state with Bias-corrected Bayesian classification.
}
\details{
Caveat: This method can be used only for continuous predictors such as gene expression profiles, 
and it does not make sense for categorical predictors such as SNP profiles.
}
\references{
Longhai Li (2012). Bias-corrected hierarchical Bayesian classification 
with a selected subset of high-dimensional features. 
\emph{Journal of the American Statistical Association}, 107(497), 120-134.
}
\seealso{
\code{\link{lasso_deltas}}
}
\keyword{internal}
