% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hzip.R
\name{hzip}
\alias{hzip}
\title{Fit a Hierarchical Zero-Inflated Poisson (HZIP) Model}
\usage{
hzip(
  formula,
  data,
  hessian = TRUE,
  method = "BFGS",
  Q = 15,
  lower = -Inf,
  upper = Inf,
  control = NULL,
  ...
)
}
\arguments{
\item{formula}{A two-part \link[Formula]{Formula} of the form
\code{y ~w_zero + ... | x_count + ... }, where the right-hand side before
the bar specifies covariates for the zero-inflation component and the right-hand side
after the bar specifies covariates for the Poisson mean.}

\item{data}{A \code{data.frame} containing all variables used in \code{formula}
and a subject identifier named \code{Ind} (one row per observation).}

\item{hessian}{Logical; if \code{TRUE} (default) the observed Hessian at the
optimum is returned and used to compute standard-error estimates.}

\item{method}{Character string passed to \code{\link[stats]{optim}}
(default \code{"BFGS"}).}

\item{Q}{Integer; number of Gauss–Hermite nodes for quadrature (default \code{15}).
Larger values improve accuracy at higher computational cost.}

\item{lower}{Bounds on the variables for the "L-BFGS-B" method, or bounds in which to search for method "Brent" (arguments passed to \code{\link[stats]{optim}}).}

\item{upper}{method, or bounds in which to search for method "Brent" (arguments passed to \code{\link[stats]{optim}}).}

\item{control}{Optional \code{list} passed to \code{\link[stats]{optim}}'s
\code{control=} argument (e.g., \code{list(maxit = 500)}).}

\item{...}{Further arguments passed to \code{\link[stats]{optim}}.}
}
\value{
An object of class \code{"HZIP"}, a \code{list} with elements:
\item{call}{The matched call.}
\item{formula}{The model \code{Formula}.}
\item{coefficients_zero}{Estimated coefficients for the zero-inflation part.}
\item{coefficients_count}{Estimated coefficients for the count part.}
\item{scale_zero}{Estimated scale (zero part).}
\item{scale_count}{Estimated scale (count part).}
\item{loglik}{Optimized objective value returned by \code{optim}.
  (Note: depending on \code{lvero}, this may be the negative log-likelihood.)}
\item{convergence}{\code{optim} convergence code.}
\item{n}{Number of observations or subjects (see \strong{Note}).}
\item{m}{Cluster sizes per subject (vector ordered by \code{Ind}).}
\item{ep}{Approximate standard errors (square roots of the diagonal of the inverse Hessian).}
\item{iter}{Number of \code{optim} iterations.}
\item{method}{Optimization method.}
\item{optim}{Raw \code{optim} output.}
\item{data}{The input \code{data}.}
}
\description{
\code{hzip()} fits a longitudinal/clustered zero-inflated Poisson model with
subject-level random effects by maximizing a (marginal) likelihood approximated.
The model uses a two-part \link[Formula]{Formula}:
\eqn{y ~ \text{zero part} \mid \text{count part}}, where the count intensity
(Poisson mean) and the zero-inflation probability are linked to (possibly
different) sets of covariates. Initial values are obtained from
\code{pscl::zeroinfl(..., dist = "poisson", link = "cloglog")}.
}
\details{
Let \eqn{y_{ij}} denote the count response for subject \eqn{i} at occasion \eqn{j}.
The HZIP model assumes
\deqn{P(y_{ij}=0 \mid u_i) = \pi_{ij}(u_i) + \{1-\pi_{ij}(u_i)\}\exp\{-\mu_{ij}(u_i)\},}
\deqn{P(y_{ij}=k \mid u_i) = \{1-\pi_{ij}(u_i)\}\frac{\mu_{ij}(u_i)^k e^{-\mu_{ij}(u_i)}}{k!},\quad k\ge 1,}
with linear predictors for the count and zero parts (links typically \code{log}
for the Poisson mean and \code{cloglog} for the zero-inflation). Subject-specific
random effects \eqn{u_i} induce within-subject dependence; the marginal likelihood
is approximated by Gauss–Hermite quadrature with \code{Q} nodes.
}
\note{
The subject identifier must be named \code{Ind}. The sign convention for the
zero-part coefficients in the initial values follows \code{pscl::zeroinfl};
the internal parameter vector is \code{c(scale_zero, -beta_zero, scale_count, beta_count)}.
Also verify whether \code{loglik} is the (negative) log-likelihood as returned by
your objective \code{lvero}; if it is the negative log-likelihood, you may want
to store \code{logLik = -op$value} for user convenience.
}
\examples{
\donttest{
fit.salamander <- hzip(y ~ mined|mined+spp,data = salamanders)
summary(fit.salamander)
}

}
\references{
Min, Y., & Agresti, A. (2005). Random effect models for repeated measures of
zero-inflated count data. \emph{Statistical Modelling}, 5(1), 1–19.

Jackman, S. (2020). \emph{pscl}: Classes and Methods for R Developed in the
Political Science Computational Laboratory. R package version 1.5.5.

Zeileis, A., & Croissant, Y. (2010). Extended model formulas in R:
\emph{Journal of Statistical Software}, 34(1), 1–13. (\pkg{Formula})
}
