% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_aggregated_difference.R
\name{plot_aggregated_differential_uptake}
\alias{plot_aggregated_differential_uptake}
\title{Plots aggregated uptake difference}
\usage{
plot_aggregated_differential_uptake(
  aggregated_diff_dat,
  fractional = TRUE,
  theoretical = FALSE,
  time_100 = max(unique(aggregated_diff_dat[["Exposure"]])),
  panels = FALSE,
  interactive = FALSE
)
}
\arguments{
\item{aggregated_diff_dat}{aggregated differential 
uptake data as calculated by \code{\link{create_aggregated_diff_uptake_dataset}}}

\item{fractional}{\code{logical}, determines if values are fractional}

\item{theoretical}{\code{logical}, determines if values are theoretical}

\item{time_100}{maximal exchange control time point of measurement [min]}

\item{panels}{\code{logical}, indicator if plot should be divided 
into panels or not}

\item{interactive}{\code{logical}, whether plot should have an interactive 
layer created with with ggiraph, which would add tooltips to the plot in an
interactive display (HTML/Markdown documents or shiny app)}
}
\value{
a \code{\link[ggplot2]{ggplot}} object
}
\description{
Plots aggregated uptake difference
}
\examples{
\donttest{
# disabled due to long execution time 

diff_uptake_dat <- create_diff_uptake_dataset(alpha_dat)
aggregated_diff_dat <- create_aggregated_diff_uptake_dataset(diff_uptake_dat)
plot_aggregated_differential_uptake(aggregated_diff_dat, panels = FALSE)
plot_aggregated_differential_uptake(aggregated_diff_dat, fractional = FALSE, 
                                    theoretical = TRUE, panels = FALSE)
plot_aggregated_differential_uptake(aggregated_diff_dat, theoretical = TRUE, 
                                    panels = TRUE)
}
}
\seealso{
\code{\link{create_diff_uptake_dataset}}
\code{\link{create_aggregated_diff_uptake_dataset}}
}
