% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_differential_butterfly.R
\name{plot_differential_butterfly}
\alias{plot_differential_butterfly}
\title{Butterfly differential deuterium uptake plot}
\usage{
plot_differential_butterfly(
  diff_uptake_dat = NULL,
  diff_p_uptake_dat = NULL,
  theoretical = FALSE,
  fractional = FALSE,
  show_houde_interval = FALSE,
  show_tstud_confidence = FALSE,
  uncertainty_type = "ribbon",
  confidence_level = 0.98,
  interactive = getOption("hadex_use_interactive_plots")
)
}
\arguments{
\item{diff_uptake_dat}{data produced by \code{\link{calculate_diff_uptake}} or
\code{\link{create_diff_uptake_dataset}} function}

\item{diff_p_uptake_dat}{differential uptake data 
alongside the P-value as calculated by 
\code{\link{create_p_diff_uptake_dataset}}}

\item{theoretical}{\code{logical}, determines if values are theoretical}

\item{fractional}{\code{logical}, determines if values are fractional}

\item{show_houde_interval}{\code{logical}, determines if houde interval is shown}

\item{show_tstud_confidence}{\code{logical}, determines if t-Student test validity 
is shown}

\item{uncertainty_type}{type of presenting uncertainty, possible values:
"ribbon", "bars" or "bars + line"}

\item{confidence_level}{confidence level for the test, from range [0, 1]
Important if selected show_confidence_limit}

\item{interactive}{\code{logical}, whether plot should have an interactive 
layer created with with ggiraph, which would add tooltips to the plot in an
interactive display (HTML/Markdown documents or shiny app).}
}
\value{
a [ggplot2::ggplot()] object.
}
\description{
Butterfly plot of differential deuterium uptake values 
between two biological states in time.
}
\details{
Function \code{\link{plot_differential_butterfly}} generates
differential butterfly plot based on provided data and parameters. On X-axis
there is peptide ID. On the Y-axis there is deuterium uptake difference in
chosen form. Data from multiple time points of measurement is presented.
If chosen, there are confidence limits based on Houde test on provided
confidence level.
}
\examples{
diff_uptake_dat <- create_diff_uptake_dataset(alpha_dat)
plot_differential_butterfly(diff_uptake_dat = diff_uptake_dat)
plot_differential_butterfly(diff_uptake_dat = diff_uptake_dat, show_houde_interval = TRUE)

diff_p_uptake_dat <- create_p_diff_uptake_dataset(alpha_dat)
plot_differential_butterfly(diff_p_uptake_dat = diff_p_uptake_dat, show_tstud_confidence = TRUE)

}
\references{
Houde, D., Berkowitz, S.A., and Engen, J.R. (2011).
The Utility of Hydrogen/Deuterium Exchange Mass Spectrometry in
Biopharmaceutical Comparability Studies. J Pharm Sci 100, 2071–2086.
}
\seealso{
\code{\link{read_hdx}}
\code{\link{create_diff_uptake_dataset}}
\code{\link{calculate_diff_uptake}}
}
