% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/replicates.R
\name{show_peptide_mass_measurement}
\alias{show_peptide_mass_measurement}
\title{Show peptide mass measurement}
\usage{
show_peptide_mass_measurement(
  rep_mass_dat,
  protein = rep_mass_dat[["Protein"]][1],
  state = rep_mass_dat[["State"]][1],
  sequence = rep_mass_dat[["Sequence"]][1],
  time_t = unique(rep_mass_dat[["Exposure"]])[3]
)
}
\arguments{
\item{rep_mass_dat}{data produced by 
\code{\link{calculate_exp_masses_per_replicate}} function.}

\item{protein}{chosen protein.}

\item{state}{biological state for chosen protein.}

\item{sequence}{sequence of chosen peptide.}

\item{time_t}{time point of the measurement.}
}
\value{
a \code{\link{data.frame}} object.
}
\description{
Show the mass measurements
from replicates for peptide in specific time point.
}
\details{
This function shows the measurements of mass from
different replicates for specific peptide in specific state
in specific time point of measurement.
}
\examples{
rep_mass_dat <- calculate_exp_masses_per_replicate(alpha_dat)
show_peptide_mass_measurement(rep_mass_dat)

}
\seealso{
\code{\link{read_hdx}}
\code{\link{calculate_exp_masses_per_replicate}}
\code{\link{calculate_exp_masses}}
\code{\link{calculate_state_uptake}}
\code{\link{calculate_diff_uptake}}
}
